<?php 
class EkobytePortfolioPost 
{
	function __construct() {
		add_action( 'init', array( $this, 'register_custom_post_type' ) );
		add_action( 'init', array( $this, 'create_cat' ) );
		add_filter( 'template_include', array( $this, 'portfolio_template_include' ) );
	}
	
	public function portfolio_template_include( $template ) {
		if ( is_singular( 'portfolio' ) ) {
			return $this->get_template( 'single-portfolio.php');
		}
		return $template;
	}
	
	public function get_template( $template ) {
		if ( $theme_file = locate_template( array( $template ) ) ) {
			$file = $theme_file;
		} 
		else {
			$file = EKOBYTE_ADDONS_DIR . '/include/template/'. $template;
		}
		return apply_filters( __FUNCTION__, $file, $template );
	}
	
	
	public function register_custom_post_type() {
        $labels = array(
            'name'               => __( 'Portfolios', 'Post Type General Name', 'ekobyte-core'),
            'singular_name'      => __( 'Portfolio', 'Post Type Singular Name', 'ekobyte-core'),
            'menu_name'          => __( 'Portfolios', 'ekobyte-core'),
            'parent_item_colon'  => __( 'Parent Portfolio', 'ekobyte-core'),
            'all_items'          => __( 'All  Portfolios', 'ekobyte-core'),
            'view_item'          => __( 'View  Portfolios', 'ekobyte-core'),
            'add_new_item'       => __( 'Add New  Portfolio', 'ekobyte-core'),
            'add_new'            => __( 'Add New  Portfolio', 'ekobyte-core'),
            'edit_item'          => __( 'Edit  Portfolio', 'ekobyte-core'),
            'update_item'        => __( 'Update  Portfolios', 'ekobyte-core'),
            'search_items'       => __( 'Search  Portfolios', 'ekobyte-core'),
            'not_found'          => __( 'Not found', 'ekobyte-core'),
            'not_found_in_trash' => __( 'Not found in Trash', 'ekobyte-core'),
        );

		$args   = array(
            'label'               => __( 'Portfolios', 'ekobyte-core'),
            'description'         => __( 'Create and manage all bdevs portfolio', 'ekobyte-core'),
            'labels'              => $labels,
            'supports'            => array( 'title','thumbnail', 'editor'),
            'hierarchical'        => false,
            'public'              => true,
            'show_ui'             => true,
            'show_in_menu'        => true,
            'show_in_nav_menus'   => true,
            'show_in_admin_bar'   => true,
            'menu_position'       => 14,
            'rewrite'             =>  array( 'slug' => 'portfolio-post', 'with_front' => false ),
            'can_export'          => true,
            'has_archive'         => true,
            'exclude_from_search' => false,
            'publicly_queryable'  => true,
            'capability_type'     => 'post',
            'menu_icon'           => 'dashicons-awards',
		);

		register_post_type( 'portfolio', $args );
	}

	public function create_cat() {
		$labels = array(
			'name'                       => esc_html_x( 'Portfolio Categories', 'Taxonomy General Name', 'ekobyte-core' ),
			'singular_name'              => esc_html_x( 'Portfolio Categories', 'Taxonomy Singular Name', 'ekobyte-core' ),
			'menu_name'                  => esc_html__( 'Portfolio Categories', 'ekobyte-core' ),
			'all_items'                  => esc_html__( 'All Portfolio Category', 'ekobyte-core' ),
			'parent_item'                => esc_html__( 'Parent Item', 'ekobyte-core' ),
			'parent_item_colon'          => esc_html__( 'Parent Item:', 'ekobyte-core' ),
			'new_item_name'              => esc_html__( 'New Portfolio Category Name', 'ekobyte-core' ),
			'add_new_item'               => esc_html__( 'Add New Portfolio Category', 'ekobyte-core' ),
			'edit_item'                  => esc_html__( 'Edit Portfolio Category', 'ekobyte-core' ),
			'update_item'                => esc_html__( 'Update Portfolio Category', 'ekobyte-core' ),
			'view_item'                  => esc_html__( 'View Portfolio Category', 'ekobyte-core' ),
			'separate_items_with_commas' => esc_html__( 'Separate items with commas', 'ekobyte-core' ),
			'add_or_remove_items'        => esc_html__( 'Add or remove items', 'ekobyte-core' ),
			'choose_from_most_used'      => esc_html__( 'Choose from the most used', 'ekobyte-core' ),
			'popular_items'              => esc_html__( 'Popular Portfolio Category', 'ekobyte-core' ),
			'search_items'               => esc_html__( 'Search Portfolio Category', 'ekobyte-core' ),
			'not_found'                  => esc_html__( 'Not Found', 'ekobyte-core' ),
			'no_terms'                   => esc_html__( 'No Portfolio Category', 'ekobyte-core' ),
			'items_list'                 => esc_html__( 'Portfolio Category list', 'ekobyte-core' ),
			'items_list_navigation'      => esc_html__( 'Portfolio Category list navigation', 'ekobyte-core' ),
		);

		$args = array(
			'labels'                     => $labels,
			'hierarchical'               => true,
			'public'                     => true,
			'show_ui'                    => true,
			'show_admin_column'          => true,
			'show_in_nav_menus'          => true,
			'show_tagcloud'              => true,
		);

		register_taxonomy('portfolio-cat','portfolio', $args );
	}

}

new EkobytePortfolioPost();