<?php
namespace EkobyteCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Repeater;
use \Elementor\Utils;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Ekobyte Core
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class Ekobyte_Team extends Widget_Base {

	/**
	 * Retrieve the widget name.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'ekobyte-team';
	}

	/**
	 * Retrieve the widget title.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Team', 'ekobytecore' );
	}

	/**
	 * Retrieve the widget icon.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'ekobyte-icon';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * Note that currently Elementor supports only one category.
	 * When multiple categories passed, Elementor uses the first one.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'ekobytecore' ];
	}

	/**
	 * Retrieve the list of scripts the widget depended on.
	 *
	 * Used to set scripts dependencies required to run the widget.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget scripts dependencies.
	 */
	public function get_script_depends() {
		return [ 'ekobytecore' ];
	}

	/**
	 * Register the widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function register_controls() {
        /**
         * Layout Section
         */
        $this->start_controls_section(
            'ekobyte_layout',
            [
                'label' => esc_html__('Design Layout', 'ekobytecore'),
            ]
        );
        $this->add_control(
            'ekobyte_design_style',
            [
                'label' => esc_html__('Select Layout', 'ekobytecore'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'layout-1' => esc_html__('Layout 1', 'ekobytecore'),
                    'layout-2' => esc_html__('Layout 2', 'ekobytecore'),
                    'layout-3' => esc_html__('Layout 3', 'ekobytecore'),
                ],
                'default' => 'layout-1',
            ]
        );

        $this->end_controls_section();

        $layout_array = ["layout-1", "layout-2"];

         /**
         * Title & Content
         */
        $this->start_controls_section(
            'ekobyte_section_title',
            [
                'label' => esc_html__('Title & Content', 'ekobytecore'),
                'condition' => [
                    'ekobyte_design_style' => $layout_array,
                ],
            ]
        );

        $this->add_control(
            'ekobyte_section_title_show',
            [
                'label' => esc_html__( 'Section Title & Content', 'ekobytecore' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Show', 'ekobytecore' ),
                'label_off' => esc_html__( 'Hide', 'ekobytecore' ),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => [
                    'ekobyte_design_style' => $layout_array,
                ],
            ]
        );

        $this->add_control(
            'ekobyte_sub_title',
            [
                'label' => esc_html__('Sub Title', 'ekobytecore'),
                'description' => ekobyte_get_allowed_html_desc( 'basic' ),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Ekobyte Sub Title', 'ekobytecore'),
                'placeholder' => esc_html__('Type Sub Heading Text', 'ekobytecore'),
                'label_block' => true,
                'condition' => [
                    'ekobyte_design_style' => $layout_array,
                ],
            ]
        );

        $this->add_control(
            'ekobyte_sub_title_color',
            [
                'label' => __( 'Sub Title Color', 'ekobytecore' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title h6' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'ekobyte_design_style' => $layout_array,
                ],
            ]
        );
        
        $this->add_control(
            'ekobyte_title',
            [
                'label' => esc_html__('Title', 'ekobytecore'),
                'description' => ekobyte_get_allowed_html_desc( 'intermediate' ),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Ekobyte Title Here', 'ekobytecore'),
                'placeholder' => esc_html__('Type Heading Text', 'ekobytecore'),
                'label_block' => true,
                'condition' => [
                    'ekobyte_design_style' => $layout_array,
                ],
            ]
        );

        $this->add_control(
            'ekobyte_title_color',
            [
                'label' => __( 'Title Color', 'ekobytecore' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title h2' => 'color: {{VALUE}}',
                ],
                'condition' => [
                    'ekobyte_design_style' => $layout_array,
                ],
            ]
        );

        $this->add_control(
            'ekobyte_title_tag',
            [
                'label' => esc_html__('Title HTML Tag', 'ekobytecore'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'h1' => [
                        'title' => esc_html__('H1', 'ekobytecore'),
                        'icon' => 'eicon-editor-h1'
                    ],
                    'h2' => [
                        'title' => esc_html__('H2', 'ekobytecore'),
                        'icon' => 'eicon-editor-h2'
                    ],
                    'h3' => [
                        'title' => esc_html__('H3', 'ekobytecore'),
                        'icon' => 'eicon-editor-h3'
                    ],
                    'h4' => [
                        'title' => esc_html__('H4', 'ekobytecore'),
                        'icon' => 'eicon-editor-h4'
                    ],
                    'h5' => [
                        'title' => esc_html__('H5', 'ekobytecore'),
                        'icon' => 'eicon-editor-h5'
                    ],
                    'h6' => [
                        'title' => esc_html__('H6', 'ekobytecore'),
                        'icon' => 'eicon-editor-h6'
                    ]
                ],
                'default' => 'h2',
                'toggle' => false,
                'condition' => [
                    'ekobyte_design_style' => $layout_array,
                ],
            ]
        );

        $this->end_controls_section();

         /**
         * Members
         */
        $this->start_controls_section(
            '_section_teams',
            [
                'label' => __( 'Members', 'ekobytecore' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new Repeater();

        $repeater->start_controls_tabs(
            '_tab_style_member_box_itemr'
        );

        $repeater->start_controls_tab(
            '_tab_member_info',
            [
                'label' => __( 'Information', 'ekobytecore' ),
            ]
        );

        $repeater->add_control(
            'image',
            [
                'type' => Controls_Manager::MEDIA,
                'label' => __( 'Image', 'ekobytecore' ),
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );                      

        $repeater->add_control(
            'title',
            [
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'label' => __( 'Name', 'ekobytecore' ),
                'default' => __( 'Member Name', 'ekobytecore' ),
                'placeholder' => __( 'Type name here', 'ekobytecore' ),
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $repeater->add_control(
            'title_color',
            [
                'label' => __( 'Name Color', 'ekobytecore' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .te-team-card .title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $repeater->add_control(
            'designation',
            [
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'show_label' => true,
                'label' => __( 'Job Title', 'ekobytecore' ),
                'default' => __( 'Ekobyte Officer', 'ekobytecore' ),
                'placeholder' => __( 'Type designation here', 'ekobytecore' ),
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $repeater->add_control(
            'ekobyte_title_color',
            [
                'label' => __( 'Job Title Color', 'ekobytecore' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .te-team-card .dec' => 'color: {{VALUE}}',
                ],
            ]
        );

        $repeater->add_control(
            'item_url',
            [
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
                'show_label' => true,
                'label' => __( 'URL', 'ekobytecore' ),
                'placeholder' => __( 'Type link here', 'ekobytecore' ),
                'default' => __( '#', 'ekobytecore' ),
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $repeater->end_controls_tab();

        $repeater->start_controls_tab(
            '_tab_member_links',
            [
                'label' => __( 'Links', 'ekobytecore' ),
            ]
        );

        $repeater->add_control(
            'show_social',
            [
                'label' => __( 'Show Options?', 'ekobytecore' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => __( 'Yes', 'ekobytecore' ),
                'label_off' => __( 'No', 'ekobytecore' ),
                'return_value' => 'yes',
                'style_transfer' => true,
            ]
        );
    

        $repeater->add_control(
            'facebook_title',
            [
                'type' => Controls_Manager::TEXT,
                'label_block' => false,
                'label' => __( 'Facebook', 'ekobytecore' ),
                'default' => __( '#', 'ekobytecore' ),
                'placeholder' => __( 'Add your facebook link', 'ekobytecore' ),
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );                

        $repeater->add_control(
            'twitter_title',
            [
                'type' => Controls_Manager::TEXT,
                'label_block' => false,
                'label' => __( 'Twitter', 'ekobytecore' ),
                'default' => __( '#', 'ekobytecore' ),
                'placeholder' => __( 'Add your twitter link', 'ekobytecore' ),
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $repeater->add_control(
            'instagram_title',
            [
                'type' => Controls_Manager::TEXT,
                'label_block' => false,
                'label' => __( 'Instagram', 'ekobytecore' ),
                'default' => __( '#', 'ekobytecore' ),
                'placeholder' => __( 'Add your instagram link', 'ekobytecore' ),
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );       

        $repeater->add_control(
            'pinterest_title',
            [
                'type' => Controls_Manager::TEXT,
                'label_block' => false,
                'label' => __( 'Pinterest', 'ekobytecore' ),
                'default' => __( '#', 'ekobytecore' ),
                'placeholder' => __( 'Add your pinterest link', 'ekobytecore' ),
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );

        $repeater->end_controls_tab();
        $repeater->end_controls_tabs();

        // Repeater
        $this->add_control(
            'teams',
            [
                'show_label' => false,
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '<# print(title || "Carousel Item"); #>',
                'default' => [
                    [
                        'image' => [
                            'url' => Utils::get_placeholder_image_src(),
                        ],
                    ],
                    [
                        'image' => [
                            'url' => Utils::get_placeholder_image_src(),
                        ],
                    ],
                    [
                        'image' => [
                            'url' => Utils::get_placeholder_image_src(),
                        ],
                    ]
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'thumbnail',
                'default' => 'medium_large',
                'separator' => 'before',
                'exclude' => [
                    'custom'
                ]
            ]
        );

        $this->add_control(
            'title_tag',
            [
                'label' => __( 'Title HTML Tag', 'ekobytecore' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'h1'  => [
                        'title' => __( 'H1', 'ekobytecore' ),
                        'icon' => 'eicon-editor-h1'
                    ],
                    'h2'  => [
                        'title' => __( 'H2', 'ekobytecore' ),
                        'icon' => 'eicon-editor-h2'
                    ],
                    'h3'  => [
                        'title' => __( 'H3', 'ekobytecore' ),
                        'icon' => 'eicon-editor-h3'
                    ],
                    'h4'  => [
                        'title' => __( 'H4', 'ekobytecore' ),
                        'icon' => 'eicon-editor-h4'
                    ],
                    'h5'  => [
                        'title' => __( 'H5', 'ekobytecore' ),
                        'icon' => 'eicon-editor-h5'
                    ],
                    'h6'  => [
                        'title' => __( 'H6', 'ekobytecore' ),
                        'icon' => 'eicon-editor-h6'
                    ]
                ],
                'default' => 'h3',
                'toggle' => false,
            ]
        );

        $this->add_responsive_control(
            'align',
            [
                'label' => __( 'Alignment', 'ekobytecore' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __( 'Left', 'ekobytecore' ),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __( 'Center', 'ekobytecore' ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => __( 'Right', 'ekobytecore' ),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'toggle' => true,
                'selectors' => [
                    '{{WRAPPER}} .single-carousel-item' => 'text-align: {{VALUE}};'
                ]
            ]
        );

        $this->end_controls_section();

		$this->start_controls_section(
			'section_style',
			[
				'label' => __( 'Style', 'ekobytecore' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'text_transform',
			[
				'label' => __( 'Text Transform', 'ekobytecore' ),
				'type' => Controls_Manager::SELECT,
				'default' => '',
				'options' => [
					'' => __( 'None', 'ekobytecore' ),
					'uppercase' => __( 'UPPERCASE', 'ekobytecore' ),
					'lowercase' => __( 'lowercase', 'ekobytecore' ),
					'capitalize' => __( 'Capitalize', 'ekobytecore' ),
				],
				'selectors' => [
					'{{WRAPPER}} .title' => 'text-transform: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();
	}

	/**
	 * Render the widget ouekobyteut on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
        ?>

        <?php if ( $settings['ekobyte_design_style']  == 'layout-3' ): 
        ?>

        <!-- Team Page Start !-->
        <div class="team-page">       
            <div class="container">
                <div class="row">
                 
                    <?php foreach ( $settings['teams'] as $key => $item ) :
                        $title = ekobyte_kses( $item['title' ] );
                        $item_url = esc_url($item['item_url']);

                        if ( !empty($item['image']['url']) ) {
                            $ekobyte_team_image_url = !empty($item['image']['id']) ? wp_get_attachment_image_url( $item['image']['id'], $settings['thumbnail_size']) : $item['image']['url'];
                            $ekobyte_team_image_alt = get_post_meta($item["image"]["id"], "_wp_attachment_image_alt", true);
                        }            
                    ?>
                    <div class="col-lg-4 col-md-6">
                        <div class="te-team-card style-2">
                            <div class="image">
                                <?php if( !empty($ekobyte_team_image_url) ) : ?>
                                    <img src="<?php echo esc_url($ekobyte_team_image_url); ?>" alt="<?php echo esc_attr($ekobyte_team_image_alt); ?>">
                                <?php endif; ?>
                            </div>
                            <div class="te-content-wrapper">
                                <div class="content">
                                    <?php if( !empty($item['show_social'] ) ) : ?> 
                                        <div class="social">
                                            <?php if( !empty($item['facebook_title'] ) ) : ?>
                                                <a href="<?php echo esc_url( $item['facebook_title'] ); ?>"><i class="fa-brands fa-facebook-f"></i></a>
                                            <?php endif; ?>
                                            <?php if( !empty($item['twitter_title'] ) ) : ?>
                                                <a href="<?php echo esc_url( $item['twitter_title'] ); ?>"><i class="fa-brands fa-twitter"></i></a>
                                            <?php endif; ?>
                                            <?php if( !empty($item['instagram_title'] ) ) : ?>
                                                <a href="<?php echo esc_url( $item['instagram_title'] ); ?>"><i class="fa-brands fa-linkedin-in"></i></a>
                                            <?php endif; ?>
                                            <?php if( !empty($item['pinterest_title'] ) ) : ?>
                                                <a href="<?php echo esc_url( $item['pinterest_title'] ); ?>"><i class="fa-brands fa-pinterest"></i></a>
                                            <?php endif; ?>
                                        </div>
                                    <?php endif; ?>
                                    <?php if( !empty($item['title']) ) : ?>
                                        <h2 class="title"><a href="<?php echo esc_url( $item['item_url'] ); ?>"><?php echo ekobyte_kses( $item['title' ] );?></a></h2>
                                    <?php endif; ?>
                                    <?php if( !empty($item['designation']) ) : ?>
                                        <p class="desc"><?php echo ekobyte_kses( $item['designation'] ); ?></p>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>  
                </div>
            </div>
        </div>
        <!-- Team Page End !-->

        <?php elseif ( $settings['ekobyte_design_style']  == 'layout-2' ): 
            $this->add_render_attribute( 'title_args', 'class', 'title' );
        ?>
        <!-- Team Member Slider Area Start -->
        <div class="team-slider-area style-2">
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <div class="te-section-title justify-content-center text-center">
                            <?php if ( !empty($settings['ekobyte_section_title_show']) ) : ?>
                                <div class="te-section-content">
                                    <?php if ( !empty($settings['ekobyte_sub_title']) ) : ?>  
                                        <div>
                                            <span class="short-title"><?php echo ekobyte_kses( $settings['ekobyte_sub_title'] ); ?></span>
                                        </div>
                                    <?php endif; ?>
                                    <?php
                                        if ( !empty($settings['ekobyte_title' ]) ) :
                                            printf( '<%1$s %2$s>%3$s</%1$s>',
                                                tag_escape( $settings['ekobyte_title_tag'] ),
                                                $this->get_render_attribute_string( 'title_args' ),
                                                ekobyte_kses( $settings['ekobyte_title' ] )
                                                );
                                        endif;
                                    ?>
                                </div>
                            <?php endif; ?> 
                        </div>
                    </div>
                </div>
            </div>
            <div class="container">
                <div class="row">
                    <div class="te-team-member-slider-wrapper" id="team_slider_wrapper">
                        <?php foreach ( $settings['teams'] as $key => $item ) :
                            $title = ekobyte_kses( $item['title' ] );
                            $item_url = esc_url($item['item_url']);

                            if ( !empty($item['image']['url']) ) {
                                $ekobyte_team_image_url = !empty($item['image']['id']) ? wp_get_attachment_image_url( $item['image']['id'], $settings['thumbnail_size']) : $item['image']['url'];
                                $ekobyte_team_image_alt = get_post_meta($item["image"]["id"], "_wp_attachment_image_alt", true);
                            }            
                        ?>  
                            <div>
                                <div class="te-team-card style-2">
                                    <div class="image">
                                        <?php if( !empty($ekobyte_team_image_url) ) : ?>
                                            <img src="<?php echo esc_url($ekobyte_team_image_url); ?>" alt="<?php echo esc_attr($ekobyte_team_image_alt); ?>">
                                        <?php endif; ?>
                                    </div>
                                    <div class="te-content-wrapper">
                                        <div class="content">
                                            <?php if( !empty($item['show_social'] ) ) : ?> 
                                                <div class="social">
                                                    <?php if( !empty($item['facebook_title'] ) ) : ?>
                                                        <a href="<?php echo esc_url( $item['facebook_title'] ); ?>"><i class="fa-brands fa-facebook-f"></i></a>
                                                    <?php endif; ?>
                                                    <?php if( !empty($item['twitter_title'] ) ) : ?>
                                                        <a href="<?php echo esc_url( $item['twitter_title'] ); ?>"><i class="fa-brands fa-twitter"></i></a>
                                                    <?php endif; ?>
                                                    <?php if( !empty($item['instagram_title'] ) ) : ?>
                                                        <a href="<?php echo esc_url( $item['instagram_title'] ); ?>"><i class="fa-brands fa-linkedin-in"></i></a>
                                                    <?php endif; ?>
                                                    <?php if( !empty($item['pinterest_title'] ) ) : ?>
                                                        <a href="<?php echo esc_url( $item['pinterest_title'] ); ?>"><i class="fa-brands fa-pinterest"></i></a>
                                                    <?php endif; ?>
                                                </div>
                                            <?php endif; ?>
                                            <?php if( !empty($item['title']) ) : ?>
                                                <h2 class="title"><a href="<?php echo esc_url( $item['item_url'] ); ?>"><?php echo ekobyte_kses( $item['title' ] );?></a></h2>
                                            <?php endif; ?>
                                            <?php if( !empty($item['designation']) ) : ?>
                                                <p class="desc"><?php echo ekobyte_kses( $item['designation'] ); ?></p>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>  
                    </div>
                </div>
            </div>
        </div>
        <!-- Team Member Slider Area End -->

        <?php else: 
            $this->add_render_attribute( 'title_args', 'class', 'title' );
        ?>

        <!-- Team Member Slider Area Start -->
        <div class="team-slider-area style-1">
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <div class="te-section-title left-align-title">
                            <?php if ( !empty($settings['ekobyte_section_title_show']) ) : ?>
                                <div class="te-section-content">
                                    <?php if ( !empty($settings['ekobyte_sub_title']) ) : ?>    
                                        <div>
                                            <span class="short-title only-divider"><?php echo ekobyte_kses( $settings['ekobyte_sub_title'] ); ?></span>
                                        </div>
                                    <?php endif; ?>
                                    <?php if ( !empty($settings['ekobyte_title' ]) ) :
                                        printf( '<%1$s %2$s>%3$s</%1$s>',
                                            tag_escape( $settings['ekobyte_title_tag'] ),
                                            $this->get_render_attribute_string( 'title_args' ),
                                            ekobyte_kses( $settings['ekobyte_title' ] )
                                        );
                                    endif; ?>
                                </div>
                            <?php endif; ?>
                            <div  class="te-section-desc">
                                <div class="te-slider-btn-wrapper">
                                    <a href="#" class="te-slider-nav te-slider-prev" id="team_slider_prev">
                                        <i class="fa-solid fa-arrow-left"></i>
                                    </a>
                                    <a href="#" class="te-slider-nav te-slider-next" id="team_slider_next">
                                        <i class="fa-solid fa-arrow-right"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="te-team-member-slider-wrapper" id="team_slider_wrapper">
                <?php foreach ( $settings['teams'] as $key => $item ) :
                    $title = ekobyte_kses( $item['title' ] );
                    $item_url = esc_url($item['item_url']);

                    if ( !empty($item['image']['url']) ) {
                        $ekobyte_team_image_url = !empty($item['image']['id']) ? wp_get_attachment_image_url( $item['image']['id'], $settings['thumbnail_size']) : $item['image']['url'];
                        $ekobyte_team_image_alt = get_post_meta($item["image"]["id"], "_wp_attachment_image_alt", true);
                    }            
                ?>
                    <div>
                        <div class="te-team-card">
                            <div class="image">
                                <?php if( !empty($ekobyte_team_image_url) ) : ?>
                                    <img src="<?php echo esc_url($ekobyte_team_image_url); ?>" alt="<?php echo esc_attr($ekobyte_team_image_alt); ?>">
                                <?php endif; ?>
                            </div>
                            <div class="te-content-wrapper">
                                <div class="content">
                                    <?php if( !empty($item['show_social'] ) ) : ?> 
                                        <div class="social">
                                            <?php if( !empty($item['facebook_title'] ) ) : ?>
                                                <a href="<?php echo esc_url( $item['facebook_title'] ); ?>"><i class="fa-brands fa-facebook-f"></i></a>
                                            <?php endif; ?>
                                            <?php if( !empty($item['twitter_title'] ) ) : ?>
                                                <a href="<?php echo esc_url( $item['twitter_title'] ); ?>"><i class="fa-brands fa-twitter"></i></a>
                                            <?php endif; ?>
                                            <?php if( !empty($item['instagram_title'] ) ) : ?>
                                                <a href="<?php echo esc_url( $item['instagram_title'] ); ?>"><i class="fa-brands fa-linkedin-in"></i></a>
                                            <?php endif; ?>
                                            <?php if( !empty($item['pinterest_title'] ) ) : ?>
                                                <a href="<?php echo esc_url( $item['pinterest_title'] ); ?>"><i class="fa-brands fa-pinterest"></i></a>
                                            <?php endif; ?>
                                        </div>
                                    <?php endif; ?>
                                    <?php if( !empty($item['title']) ) : ?>
                                        <h2 class="title"><a href="<?php echo esc_url( $item['item_url'] ); ?>"><?php echo ekobyte_kses( $item['title' ] );?></a></h2>
                                    <?php endif; ?>

                                    <?php if( !empty($item['designation']) ) : ?>
                                        <p class="desc"><?php echo ekobyte_kses( $item['designation'] ); ?></p>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>  
            </div>
        </div>
        <!-- Team Member Slider Area End -->

        <?php endif; ?>

        <?php
	}
}

$widgets_manager->register( new Ekobyte_Team() );