<?php
if (!defined('ABSPATH')) exit;

/**
 * Admin Page Callback
 * REGISTERED IN MENU
 */

function interlink_products_admin_page() {
    /* =========================
       SAVE PRODUCT (ADD / EDIT)
    ========================= */
    if (
        isset($_POST['ipm_save_product']) &&
        check_admin_referer('ipm_save_product', '_ipm_product_nonce')
    ) {
        
        
        $post_id = intval($_POST['product_id'] ?? 0);
            
        $post_data = [
            'post_type'    => 'ipm_product',
            'post_title'   => sanitize_text_field($_POST['product_title']),
            'post_status'  => sanitize_text_field($_POST['product_status']),
            'post_content' => wp_kses_post($_POST['product_description']),
        ];

        $post_id = $post_id
            ? wp_update_post(array_merge($post_data, ['ID' => $post_id]))
            : wp_insert_post($post_data);

        if (!is_wp_error($post_id)) {

            // Category
            if (!empty($_POST['product_category'])) {
                wp_set_object_terms($post_id, intval($_POST['product_category']), 'product_category');
            }

            // Featured Image
            if (!empty($_POST['featured_image_id'])) {
                set_post_thumbnail($post_id, intval($_POST['featured_image_id']));
            }

            // Meta Fields
            $meta_fields = [
                'product_dimension',
                'product_features',
                'warranty_details',
                'accessories',
                'youtube_url',
                'product_pdf',
                'gallery_image_1',
                'gallery_image_2',
                'gallery_image_3',
                'meta_title',
                'meta_description',
                'meta_keywords',
            ];

            foreach ($meta_fields as $key) {
                update_post_meta($post_id, $key, wp_kses_post($_POST[$key] ?? ''));
            }

            echo '<div class="updated notice"><p>Product saved successfully.</p></div>';
        }
    }
    // $show_form = isset($_GET['edit']) && intval($_GET['edit']) > 0;
    $is_edit = isset($_GET['edit']) && intval($_GET['edit']) > 0;
    $is_add  = isset($_GET['add']);

    $show_form = $is_edit || $is_add;

    /* =========================
       DELETE PRODUCT
    ========================= */
    if (isset($_GET['ipm_delete'])) {
        wp_delete_post(intval($_GET['ipm_delete']), true);
        echo '<div class="updated notice"><p>Product deleted.</p></div>';
    }

    // /* =========================
    //    LOAD UI
    // ========================= */
    // require __DIR__ . '/products-list.php';
    // require __DIR__ . '/products-form.php';
}
