<?php
if (!defined('ABSPATH')) exit;

$products = get_posts([
    'post_type' => 'ipm_product',
    'numberposts' => -1
]);
?>

<div style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 16px; margin-right: 16px;">
<h2>Product List</h2>
<div class="ipm-toolbar">
    <button type="button" id="ipm-add-new" class="button button-primary">
        ➕ Add New Product
    </button>
</div>
</div>
<table class="widefat striped">
<thead>
<tr>
    <th>Image</th>
    <th>Name</th>
    <th>Status</th>
    <th>Action</th>
</tr>
</thead>
<tbody>
<?php foreach ($products as $p): ?>
<tr>
    <td>
        <?php if (has_post_thumbnail($p->ID)){ ?>
        <?= get_the_post_thumbnail($p->ID, [60,60]) ?>
        <?php } else {
                    ?>
                        <div class="ipm-product-placeholder" style="width: 60px; height: 60px; aspect-ratio: 1; background: linear-gradient(135deg, #f5f5f5 0%, #e8e8e8 100%); display: flex; align-items: center; justify-content: center; color: #999; font-size: 11px; font-weight: 500; letter-spacing: 0.5px;">
                            NO IMAGE
                        </div>
                    <?php
                    }
                    ?>
    </td>
    <td><?= esc_html($p->post_title) ?></td> 
    <td><?= esc_html($p->post_status) ?></td>
    <td>
        <a class="ipm-edit" href="?page=ipm-products&edit=<?= $p->ID ?>">Edit</a> |
        <a style="color: red;" href="?page=ipm-products&ipm_delete=<?= $p->ID ?>"
           onclick="return confirm('Delete this product?')">Delete</a>
    </td>
</tr>
<?php endforeach; ?>
</tbody>
</table>
<?php
wp_reset_postdata(); ?>