<?php
if (!defined('ABSPATH')) exit;

class IPM_Admin
{

    public static function init()
    {
         require_once IPM_PLUGIN_DIR . 'includes/support/admin/class-ipm-support-admin.php';
        add_action('admin_menu', [__CLASS__, 'menu']);
    }

    public static function menu()
    {

        add_menu_page(
            'Products Management System',
            'Products Management',
            'edit_posts',
            'ipm-products',
            [__CLASS__, 'render_products_page'],
            'dashicons-products',
            26
        );

        add_submenu_page(
            'ipm-products',
            'Categories',
            'Categories',
            'manage_options',
            'ipm-categories',
            [__CLASS__, 'render_categories_page']
        );

        add_submenu_page(
            'ipm-products',
            'Client Partners',
            'Client Partners',
            'manage_options',
            'ipm-clients',
            [__CLASS__, 'render_clients_page']
        );

        add_submenu_page(
            'ipm-products',
            'Support',
            'Support',
            'manage_options',
            'ipm-support',
            ['IPM_Support_Admin', 'render_support_list']
        );

        add_submenu_page(
            'ipm-products',
            'Support Types',
            'Support Types',
            'manage_options',
            'ipm-support-types',
            ['IPM_Support_Admin', 'render_support_types']
        );
    }

    public static function render_products_page()
    {

        require_once IPM_PLUGIN_DIR . 'includes/admin/products-add.php';
        require_once IPM_PLUGIN_DIR . 'includes/admin/products-list.php';
        require_once IPM_PLUGIN_DIR . 'includes/admin/products-form.php';

        interlink_products_admin_page();
    }
    public static function render_categories_page()
    {
        require_once IPM_PLUGIN_DIR . 'includes/admin/category-list-add.php';
        interlink_category_list_admin_page();
    }
    public static function render_clients_page()
    {
        require_once IPM_PLUGIN_DIR . 'includes/admin/client-partner-admin.php';
        interlink_client_partner_admin_page();
    }
}
