<?php
if (!defined('ABSPATH')) exit;

/**
 * Custom breadcrumb for product category pages
 * Overrides theme/plugin breadcrumbs
 */

add_filter('wpseo_breadcrumb_output', function ($breadcrumb) {
    // Only override on category pages
    if (!is_tax('product_category')) {
        return $breadcrumb;
    }

    $term = get_queried_object();
    if (!$term || empty($term->term_id)) {
        return $breadcrumb;
    }

    // Build custom breadcrumb
    $home_url = home_url('/');
    $category_url = get_term_link($term->term_id, 'product_category');

    return '<div class="breadcrumb">' .
           '<a href="' . esc_url($home_url) . '">Home</a> > ' .
           '<span class="current">' . esc_html($term->name) . '</span>' .
           '</div>';
});