<?php
if (!defined('ABSPATH')) exit;

/* ================================
   SHORTCODE: CLIENT PARTNER SLIDER
================================ */
add_shortcode('interlink_client_partners', function () {

    // Load partners from admin option
    $partners = get_option('interlink_client_partners', []);

    if (empty($partners)) {
        return '';
    }

    // Only ACTIVE partners with logo
    $partners = array_values(array_filter($partners, function ($p) {
        return ($p['status'] ?? '') === 'active' && !empty($p['logo']);
    }));

    if (empty($partners)) {
        return '';
    }

    // -----------------------------
    // SLIDE PREPARATION (IMPORTANT)
    // -----------------------------
    $items_per_slide = 8; // 2 rows × 4 logos
    $client_slides   = array_chunk($partners, $items_per_slide);

    if (empty($client_slides)) {
        return '';
    }

    ob_start();
?>

<!-- Slick CSS -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick.min.css"/>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick-theme.min.css"/>
<section class="container px-0 py-10">
<!-- Slider Wrapper -->
<div class="clients-slider-wrapper">
    <div class="clients-slick-slider">

        <?php foreach ($client_slides as $slide_clients): ?>
            <div class="slide-item">
                <div class="rows-container">

                    <!-- FIRST ROW -->
                    <div class="clients-row">
                        <?php
                        $half = ceil(count($slide_clients) / 2);
                        $first_row = array_slice($slide_clients, 0, $half);

                        foreach ($first_row as $client):
                        ?>
                            <div class="client-item">
                                <div class="logo-container">
                                    <img src="<?= esc_url($client['logo']) ?>"
                                         alt="<?= esc_attr($client['name'] ?? 'Brand Logo') ?>">
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>

                    <!-- SECOND ROW -->
                    <div class="clients-row">
                        <?php
                        $second_row = array_slice($slide_clients, $half);

                        foreach ($second_row as $client):
                        ?>
                            <div class="client-item">
                                <div class="logo-container">
                                    <img src="<?= esc_url($client['logo']) ?>"
                                         alt="<?= esc_attr($client['name'] ?? 'Brand Logo') ?>">
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>

                </div>
            </div>
        <?php endforeach; ?>

    </div>
</div>
</section>
<!-- jQuery & Slick JS -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/slick-carousel/1.8.1/slick.min.js"></script>

<style>
/* =========================
   CLIENT SLIDER STYLES
========================= */
.clients-slider-wrapper {
    width: 100%;
    padding: 20px 15px;
}

.slide-item {
    padding: 0 10px;
}

.rows-container {
    display: flex;
    flex-direction: column;
    gap: 20px;
}

.clients-row {
    display: flex;
    justify-content: center;
    align-items: center;
    gap: 20px;
    flex-wrap: wrap;
}

.client-item {
    flex: 1;
    min-width: 150px;
}

.logo-container {
    display: flex;
    align-items: center;
    justify-content: center;
    height: 90px;
    padding: 15px;
    background: #fff;
    border-radius: 8px;
    border: 1px solid #e0e0e0;
    transition: all 0.3s ease;
}

.logo-container img {
    max-height: 60px;
    max-width: 100%;
    object-fit: contain;
    filter: grayscale(20%);
    transition: filter 0.3s ease;
}

.logo-container:hover img {
    filter: grayscale(0%);
}

.logo-container:hover {
    box-shadow: 0 4px 12px rgba(0,0,0,0.1);
    transform: translateY(-2px);
}
.clients-slider-wrapper >* .slick-prev:before {
    content: '\f053';
    font-family: 'Font Awesome 6 Pro';
}
.clients-slider-wrapper >* .slick-next:before {
    content: '\f054';
    font-family: 'Font Awesome 6 Pro';
}
/* Slick arrows */
.clients-slider-wrapper >* .slick-prev,
.clients-slider-wrapper >* .slick-next {
    width: 40px;
    height: 40px;
    z-index: 10;
}

.clients-slider-wrapper >* .slick-prev:before,
.clients-slider-wrapper >* .slick-next:before {
    font-size: 1rem;
    color: var(--e-global-color-accent);
    border: 1px solid currentColor;
    padding: 0.33rem 0.55rem;
    border-radius: 50%;
    display: inline-flex;
    align-items: center;
    justify-content: center;
}


/* Responsive */
@media (max-width: 768px) {
    .clients-slider-wrapper >* .slick-prev,
    .clients-slider-wrapper >* .slick-next {
        display: none !important;
    }

    .client-item {
        min-width: 100px;
    }

    .logo-container {
        height: 70px;
    }

    .logo-container img {
        max-height: 45px;
    }
}
</style>

<script>
jQuery(document).ready(function($){

    $('.clients-slick-slider').slick({
        dots: true,
        infinite: true,
        speed: 500,
        slidesToShow: 1,
        slidesToScroll: 1,
        autoplay: true,
        autoplaySpeed: 4000,
        pauseOnHover: true,
        arrows: true,
        responsive: [
            {
                breakpoint: 768,
                settings: {
                    arrows: false,
                    dots: true
                }
            },
            {
                breakpoint: 480,
                settings: {
                    arrows: false,
                    dots: false
                }
            }
        ]
    });

});
</script>

<?php
    return ob_get_clean();
});
