<?php
if (!defined('ABSPATH')) exit;

get_header();

global $post;

$gallery = [
    get_post_meta($post->ID, 'gallery_image_1', true),
    get_post_meta($post->ID, 'gallery_image_2', true),
    get_post_meta($post->ID, 'gallery_image_3', true),
];

$product_features  = get_post_meta($post->ID, 'product_features', true);
$warranty_details  = get_post_meta($post->ID, 'warranty_details', true);
$accessories       = get_post_meta($post->ID, 'accessories', true);
$product_pdf       = get_post_meta($post->ID, 'product_pdf', true);
$youtube_url       = get_post_meta($post->ID, 'youtube_url', true);
?>
<style>
    /* PRODUCT SINGLE */
    .ipm-product-hero {
        padding: 40px 0;
        background: #f5f7fa;
    }

    .ipm-product-title {
        font-size: 32px;
        font-weight: 700;
    }

    .ipm-product-layout {
        display: grid;
        grid-template-columns: 1fr 1fr;
        gap: 40px;
        margin-top: 40px;
    }

    .ipm-product-main-image img {
        width: 100%;
        border-radius: 12px;
    }

    .ipm-product-gallery {
        display: flex;
        gap: 10px;
        margin-top: 15px;
    }

    .ipm-product-gallery img {
        width: 90px;
        height: 90px;
        object-fit: cover;
        border-radius: 8px;
        cursor: pointer;
    }

    .ipm-product-info h3 {
        margin-top: 25px;
        font-size: 20px;
    }

    .ipm-product-btn {
        display: inline-block;
        margin: 20px auto;
        padding: 0px 20px;
        background: var(--interlink-accent-color);
        color: #fff;
        border-radius: 30px;
        text-decoration: none;
    }

    .ipm-product-btn:hover {
        background: var(--interlink-secondary-color);
        color: #fff;
    }

    .ipm-product-video iframe {
        width: 100%;
        height: 420px;
        margin-top: 50px;
        border-radius: 12px;
    }

    @media (max-width: 900px) {
        .ipm-product-layout {
            grid-template-columns: 1fr;
        }
    }

    /* PRODUCT ACCORDION */
    .ipm-product-accordion {
        border-top: 1px solid #e5e7eb;
        margin-top: 30px;
    }

    .ipm-accordion-item {
        border-bottom: 1px solid #e5e7eb;
    }

    .ipm-accordion-header {
        width: 100%;
        background: none;
        border: none;
        padding: 16px 0;
        font-size: 16px;
        font-weight: 600;
        color: var(--interlink-secondary-color);
        display: flex;
        justify-content: space-between;
        align-items: center;
        cursor: pointer;
    }

    .ipm-accordion-header:hover {
        color: var(--interlink-primary-color);
    }

    .ipm-accordion-icon {
        font-size: 20px;
        transition: transform 0.3s ease;
    }

    .ipm-accordion-content {
        display: none;
        padding: 0 0 20px;
        color: #4b5563;
        line-height: 1.7;
    }

    /* ACTIVE STATE */
    .ipm-accordion-item.active .ipm-accordion-content {
        display: block;
    }

    .ipm-accordion-item.active .ipm-accordion-icon {
        transform: rotate(45deg);
    }

    /* IPM QUOTE POPUP */
    .ipm-popup-overlay {
        position: fixed;
        inset: 0;
        background: rgba(0, 0, 0, 0.65);
        display: none;
        align-items: center;
        justify-content: center;
        z-index: 9999;
    }

    .ipm-popup-overlay.is-active {
        display: flex;
    }

    .ipm-popup {
        background: #fff;
        /* max-width: 520px; */
        max-width: min-content;
        width: 92%;
        padding: 5px 28px;
        border-radius: 12px;
        position: relative;
        box-shadow: 0 20px 60px rgba(0, 0, 0, 0.25);
        animation: ipmFadeUp 0.25s ease;
    }

    .ipm-popup-title {
        margin-bottom: 18px;
        font-size: 22px;
        font-weight: 600;
        color: var(--interlink-secondary-color);
    }

    .ipm-popup-close {
        position: absolute;
        top: 12px;
        right: 14px;
        background: none;
        border: none;
        font-size: 28px;
        cursor: pointer;
        line-height: 1;
    }

    @keyframes ipmFadeUp {
        from {
            opacity: 0;
            transform: translateY(15px);
        }

        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    .ipm-popup>* input,
    .ipm-popup>* textarea {
        border: 1px solid #c6c6c6;
        padding-left: 0.3rem;
    }

    .wpcf7-form-control.wpcf7-submit.has-spinner {
        width: 100%;
        background: var(--interlink-accent-color);
        color: white;
        border-radius: 25px;
        border: none;
        box-shadow: 0 0px 2px 0 #868686;
    }

    /* IPM Slider Products */
    .ipm-product-media {
        position: relative;
    }

    /* MAIN IMAGE */
    .ipm-product-main-slider img {
        width: 100%;
        height: 530px;
        object-fit: contain;
        border-radius: 14px;
        background: #fff;
    }

    /* ARROWS */
    .ipm-slick-arrow {
        position: absolute;
        top: 50%;
        transform: translateY(-50%);
        width: 44px;
        height: 44px;
        background: rgba(0, 0, 0, 0.65);
        border: none;
        border-radius: 50%;
        z-index: 10;
        cursor: pointer;
        display: flex;
        align-items: center;
        justify-content: center;
    }

    .ipm-slick-arrow svg {
        width: 18px;
        height: 18px;
        fill: none;
        stroke: #fff;
        stroke-width: 2.5;
    }

    .ipm-prev {
        left: 6px;
    }

    .ipm-next {
        right: 6px;
    }

    .ipm-slick-arrow:hover {
        background: var(--interlink-accent-color);
    }

    /* ===============================
   THUMBNAILS
================================ */

    .ipm-product-thumb-slider {
        margin-top: 14px;
    }

    .ipm-product-thumb-slider .slick-slide {
        padding: 6px;
    }

    .ipm-product-thumb-slider img {
        width: 100%;
        height: 80px;
        object-fit: contain;
        border-radius: 10px;
        cursor: pointer;
        opacity: 0.5;
        border: 2px solid transparent;
        transition: all 0.25s ease;
        background: #fff;
    }

    .ipm-product-thumb-slider .slick-current img {
        opacity: 1;
        border-color: var(--interlink-accent-color);
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
    }

    .ipm-product-thumb-slider img:hover {
        opacity: 1;
    }

    /* MOBILE TWEAKS */
    @media (max-width: 768px) {
        .ipm-product-thumb-slider img {
            height: 65px;
        }

        .ipm-product-main-slider img {
            height: 300px;
            object-fit: contain;
        }

        .ipm-slick-arrow {
            width: 30px;
            height: 30px;
        }

        .ipm-product-layout {
            margin-top: 20px;
        }

        .wpcf7-form-control {
            width: 280px;
        }
    }

    .ipm-product-media {
        width: 100%;
        overflow: hidden;
    }
</style>
<main class="ipm-product-single">

    <!-- ===== HERO ===== -->
    <section class="ipm-product-hero d-none">
        <div class="container">
            <h1 class="ipm-product-title"><?php the_title(); ?></h1>
        </div>
    </section>

    <!-- ===== MAIN CONTENT ===== -->
    <section class="container ipm-product-wrapper">

        <div class="ipm-product-layout">

            <!-- LEFT: IMAGES -->
            <div class="ipm-product-media">

                <!-- MAIN SLIDER -->
                <div class="ipm-product-main-slider">

                    <?php if (has_post_thumbnail()): ?>
                        <div>
                            <?php the_post_thumbnail('large'); ?>
                        </div>
                    <?php else: ?>
                        <div class="ipm-product-placeholder" style="width: 100%; aspect-ratio: 1; background: linear-gradient(135deg, #f5f5f5 0%, #e8e8e8 100%); display: flex; align-items: center; justify-content: center; color: #999; font-size: 13px; font-weight: 500; letter-spacing: 0.5px;">
                            NO IMAGE
                        </div>
                    <?php endif; ?>

                    <?php if (!empty($gallery)): ?>
                        <?php foreach ($gallery as $img_id): ?>
                            <?php if ($img_id): ?>
                                <div>
                                    <img src="<?php echo esc_url(wp_get_attachment_url($img_id)); ?>" width="100%" height="auto" alt="">
                                </div>
                            <?php endif; ?>
                        <?php endforeach; ?>
                    <?php endif; ?>

                </div>

                <!-- THUMBNAILS -->
                <?php if (!empty($gallery)): ?>
                    <div class="ipm-product-thumb-slider">

                        <?php if (has_post_thumbnail()): ?>
                            <div>
                                <?php the_post_thumbnail('thumbnail'); ?>
                            </div>
                        <?php endif; ?>

                        <?php foreach ($gallery as $img_id): ?>
                            <?php if ($img_id): ?>
                                <div>
                                    <img src="<?php echo esc_url(wp_get_attachment_image_url($img_id, 'thumbnail')); ?>" alt="">
                                </div>
                            <?php endif; ?>
                        <?php endforeach; ?>

                    </div>
                <?php endif; ?>

            </div>

            <!-- RIGHT: DETAILS -->
            <div class="ipm-product-info">

                <div class="ipm-product-description">
                    <?php the_content(); ?>
                </div>

                <div class="ipm-product-accordion">

                    <?php if ($product_features): ?>
                        <div class="ipm-accordion-item">
                            <button class="ipm-accordion-header">
                                Key Features
                                <span class="ipm-accordion-icon">+</span>
                            </button>
                            <div class="ipm-accordion-content">
                                <?php echo wpautop($product_features); ?>
                            </div>
                        </div>
                    <?php endif; ?>

                    <?php if ($accessories): ?>
                        <div class="ipm-accordion-item">
                            <button class="ipm-accordion-header">
                                Accessories
                                <span class="ipm-accordion-icon">+</span>
                            </button>
                            <div class="ipm-accordion-content">
                                <?php echo wpautop($accessories); ?>
                            </div>
                        </div>
                    <?php endif; ?>

                    <?php if ($warranty_details): ?>
                        <div class="ipm-accordion-item">
                            <button class="ipm-accordion-header">
                                Warranty
                                <span class="ipm-accordion-icon">+</span>
                            </button>
                            <div class="ipm-accordion-content">
                                <?php echo wpautop($warranty_details); ?>
                            </div>
                        </div>
                    <?php endif; ?>

                </div>

                <button class="ipm-product-btn ipm-open-quote">
                    Get Quotation
                </button>

                <?php if ($product_pdf): ?>
                    <a class="ipm-product-btn"
                        href="<?php echo esc_url($product_pdf); ?>"
                        target="_blank">
                        Download Catalog (PDF)
                    </a>
                <?php endif; ?>

            </div>

        </div>

        <?php if ($youtube_url): ?>

            <?php
            preg_match(
                '%(?:youtube(?:-nocookie)?\.com/(?:[^/]+/.+/|(?:v|e(?:mbed)?)/|.*[?&]v=)|youtu\.be/)([^"&?/ ]{11})%i',
                $youtube_url,
                $matches
            );
            $video_id = $matches[1] ?? '';
            ?>

            <?php if ($video_id): ?>
                <div class="ipm-product-video mb-4">
                    <h3 class="mt-3 h5 text-center">Product Demonstration</h3>
                    <iframe
                        src="https://www.youtube.com/embed/<?php echo esc_attr($video_id); ?>"
                        frameborder="0" class="mt-0"
                        allowfullscreen>
                    </iframe>
                </div>
            <?php endif; ?>

        <?php endif; ?>

        <div class="feature-area style-2" style="padding-bottom: 0; padding-top: 1rem;">
            <div class="container">
                <div class="feature-area-wrapper">
                    <div class="row">
                        <div class="col-12">
                            <div class="te-section-title justify-content-center text-center" style="margin-bottom: 30px;">
                                <div class="te-section-content">

                                    <div>
                                        <span class="short-title">Our Trusted Client Network</span>
                                    </div>
                                    <h2 class="title">Brands That Trust Scanlife</h2>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php echo do_shortcode('[interlink_client_partners]'); ?>
    </section>
    <!-- IPM Quote Popup -->
    <div id="ipm-quote-popup" class="ipm-popup-overlay" aria-hidden="true">

        <div class="ipm-popup">
            <button class="ipm-popup-close" aria-label="Close popup">&times;</button>

            <h3 class="ipm-popup-title">Request a Quotation</h3>

            <div class="ipm-popup-form">
                <?php echo do_shortcode('[contact-form-7 id="147460b" title="Product Enquire Form"]'); ?>
            </div>
        </div>

    </div>

</main>

<?php get_footer(); ?>