<?php
if (!defined('ABSPATH')) exit;

$is_edit = isset($item) && is_array($item);
?>
<style>
    :root {
        --primary-color: #0073aa;
        --primary-hover: #005a87;
        --danger-color: #d63638;
        --border-color: #dcdcde;
        --bg-light: #f6f7f7;
        --bg-white: #FAFAFA;
        --text-dark: #1e1e1e;
        --text-muted: #646970;
        --shadow-sm: 0 1px 3px rgba(0, 0, 0, 0.08);
        --shadow-md: 0 2px 8px rgba(0, 0, 0, 0.1);
        --radius-sm: 4px;
        --radius-md: 8px;
        --transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    }

    .ipm-card {
        background: var(--bg-white);
        border: 1px solid var(--border-color);
        border-radius: var(--radius-md);
        padding: 24px;
        box-shadow: var(--shadow-sm);
        transition: var(--transition);
    }

    .ipm-card:hover {
        box-shadow: var(--shadow-md);
        border-color: var(--primary-color);
    }

    .ipm-form-title {
        font-size: 1.2rem;
        font-weight: 600;
        color: var(--text-dark);
        margin-bottom: 24px;
        padding: 10px 20px;
        background: var(--bg-white);
        border: 1px solid var(--border-color);
        border-radius: var(--radius-md);
        width: fit-content;
    }

    .ipm-field {
        margin-bottom: 20px;
        display: flex;
        flex-direction: column;
    }

    .ipm-field:last-child {
        margin-bottom: 0;
    }

    .ipm-field label {
        display: block;
        font-size: 14px;
        font-weight: 600;
        color: var(--text-dark);
        margin-bottom: 8px;
        letter-spacing: -0.2px;
    }

    .ipm-field input[type="text"],
    .ipm-field input[type="url"],
    .ipm-field textarea {
        padding: 10px 12px;
        font-size: 14px;
        border: 1px solid var(--border-color);
        border-radius: var(--radius-sm);
        background: var(--bg-white);
        color: var(--text-dark);
        transition: var(--transition);
        font-family: inherit;
        width: 100%;
    }

    .ipm-field input[type="text"]:focus,
    .ipm-field input[type="url"]:focus,
    .ipm-field textarea:focus {
        outline: none;
        border-color: var(--primary-color);
        box-shadow: 0 0 0 3px rgba(0, 115, 170, 0.1);
        background: var(--bg-white);
    }

    .ipm-field textarea {
        resize: vertical;
        min-height: 100px;
        line-height: 1.5;
    }

    .ipm-required::after {
        content: '*';
        color: var(--danger-color);
        margin-left: 4px;
        font-weight: 700;
    }

    .ipm-row {
        display: grid;
        grid-template-columns: 1fr 1fr;
        gap: 16px;
    }

    .ipm-row.full {
        grid-template-columns: 1fr;
    }

    .button {
        display: inline-flex;
        align-items: center;
        gap: 6px;
        padding: 8px 16px;
        font-size: 14px;
        font-weight: 600;
        border: 1px solid var(--border-color);
        border-radius: var(--radius-sm);
        background: var(--bg-white);
        color: var(--text-dark);
        cursor: pointer;
        transition: var(--transition);
        text-decoration: none;
    }

    .button:hover {
        background: var(--bg-light);
        border-color: var(--primary-color);
        color: var(--primary-color);
    }

    .button-primary {
        background: var(--primary-color);
        color: white;
        border-color: var(--primary-color);
    }

    .button-primary:hover {
        background: var(--primary-hover);
        border-color: var(--primary-hover);
    }

    .button-large {
        padding: 12px 24px;
        font-size: 16px;
        width: 100%;
        justify-content: center;
    }

    .ipm-submit {
        margin-top: 32px;
        display: flex;
        gap: 12px;
        justify-content: flex-end;
    }

    .ipm-form-wrapper {
        max-width: 800px;
        margin: 0 auto;
    }

    @media (max-width: 768px) {
        .ipm-row {
            grid-template-columns: 1fr;
        }

        .ipm-submit {
            flex-direction: column;
        }

        .button-large {
            width: 100%;
        }
    }

    @keyframes slideIn {
        from {
            opacity: 0;
            transform: translateY(10px);
        }

        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    .ipm-card {
        animation: slideIn 0.3s ease-out;
    }
</style>
<h2 style="margin-top:20px">
    <?php echo $is_edit ? 'Edit Support Link' : 'Add Support Link'; ?>
</h2>

<form method="post" style="background:#fff;padding:20px;border:1px solid #ccd0d4;max-width:800px">
    <?php wp_nonce_field('ipm_save_support'); ?>

    <input type="hidden" name="support_index"
           value="<?php echo esc_attr($edit_index ?? ''); ?>">

    <table class="form-table">
        <tr>
            <th><label>Product Name</label></th>
            <td>
                <input type="text"
                       name="product_name"
                       class="regular-text"
                       value="<?php echo esc_attr($item['product_name'] ?? ''); ?>"
                       required>
            </td>
        </tr>

        <tr>
            <th><label>Type</label></th>
            <td>
                <select name="type" required>
                    <option value="">— Select Type —</option>
                    <?php foreach ($support_types as $t): ?>
                        <?php if ($t['status'] === 'active'): ?>
                            <option value="<?php echo esc_attr($t['name']); ?>"
                                <?php selected($item['type'] ?? '', $t['name']); ?>>
                                <?php echo esc_html($t['name']); ?>
                            </option>
                        <?php endif; ?>
                    <?php endforeach; ?>
                </select>
            </td>
        </tr>

        <tr>
            <th><label>Description</label></th>
            <td>
                <?php
                wp_editor(
                    $item['description'] ?? '',
                    'description',
                    [
                        'textarea_name' => 'description',
                        'media_buttons' => true,
                        'textarea_rows' => 6,
                    ]
                );
                ?>
            </td>
        </tr>

        <tr>
            <th><label>Driver URL</label></th>
            <td>
                <input type="url"
                       name="driver_url"
                       class="regular-text"
                       value="<?php echo esc_url($item['driver_url'] ?? ''); ?>">
            </td>
        </tr>
    </table>

    <p>
        <button type="submit" class="button button-primary">
            <?php echo $is_edit ? 'Update Support Link' : 'Save Support Link'; ?>
        </button>
        <?php if ($is_edit): ?>
            <a href="<?php echo admin_url('admin.php?page=ipm-support'); ?>"
               class="button">Cancel</a>
        <?php endif; ?>
    </p>
</form>